<?php

use App\Models\Pyramid;
use App\Models\User;
use App\Models\VerifyEmail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Illuminate\Support\Facades\Hash;

require_once "v1/userApi.php";
require_once "v1/pyramid.php";
require_once "v1/taskApi.php";
require_once "v1/ticketApi.php";
Route::get('/test', function (Request $request) {
  return response()->json(["error" => false, "message" => "done"], 200);
});

Route::get('/user', function (Request $request) {
  return $request->user();
})->middleware('auth:sanctum');


// * email verify

Route::get('/email/verify/{id}/{hash}', function (Request $request) {
  //$request->fulfill();

  //return redirect('/');
  $user = User::findOrFail($request->id);

  if ($user->hasVerifiedEmail()) {
    return response()->json(['message' => '$user->hasVerifiedEmail()'], 200);
  }


  $expectedHash = VerifyEmail::whereUserId($request->id)->first();
  if ($request->hash !== $expectedHash->token) {
    return   response()->json(['message' => 'Invalid verification link.', 'user' => $user, 'hash' => $request->hash, 'token' => $expectedHash], 200);
  }

  if ($user->email_verified_at !== null) {
    return
      response()->json(['message' => 'Email already verified.',], 200);
  }


  //update parent pyramid
  $parentUser = User::whereReferral($user->sub_of)->first();
  if (!$parentUser) {
    return response()->json(
      [
        "error" => true,
        "message" => "Invalid referral code.",
        "ref" => $user->sub_of
      ],
      400
    );
  }
  if ($parentUser->sub_count >= 12) {
    return response()->json([
      "error" => true,
      "message" => "Maximum number of usages exceeded."
    ], 400);
  }



  //add to parent subs
  $parentUser->sub_count = $parentUser->sub_count + 1;
  $subs = $parentUser->subs ? json_decode($parentUser->subs, true) : [];
  $count = count($subs);
  $newSub = ['index' => $count, 'id' => $user->id,];
  // if (!in_array($user->id, $subs)) {
  //   $subs[] = $user->id;
  // }
  $subs[] = $newSub;
  $parentUser->subs = json_encode($subs);
  $parentUser->save();


  // update pyramids

  $prevInx = 1;
  $subInx = $count;
  $pow = 1;
  for ($i = 0; $i < 7; $i++) {
    $pageIndex = floor($subInx / 2);
    $itemIndx = $pow * (1 + $subInx % 2) + $prevInx;
    $pyramid = Pyramid::whereUserId($parentUser->id)->wherePage($pageIndex)->first();
    if ($pyramid) {
      $newItem = ['index' => $itemIndx, 'id' => $user->id,];
      $items = $pyramid->items ? json_decode($pyramid->items, true) : [];
      $items[] = $newItem;
      $pyramid->items = json_encode($items);
      $pyramid->save();
    } else {
      $newItem = ['index' => 2, 'id' => $user->id,];
      $items[] = $newItem;
      $pyramid = Pyramid::create([
        'user_id' => $parentUser->id,
        'page' => $pageIndex,
        'items' => json_encode($items)
      ]);
      $pyramid->save();
    }
    $subInx2 = $parentUser->sub_index;
    $parentUser = User::whereReferral($parentUser->sub_of)->first();
    if ($subInx > 2 || !$parentUser) {
      break;
    }
    $subInx = $subInx2;
    $pow = $pow * 2;
    $prevInx = $itemIndx;
  }
  // foreach ($subs as &$sub) {
  //   if ($sub['index'] === $indexToUpdate) {
  //     $sub['id'] = $newId;
  //     break;
  //   }

  //

  $user->sub_index = $count;
  $user->save();
  $user->markEmailAsVerified();
  return response()->json(['message' => 'Email verified successfully.'], 200);
})->name('verification.verify'); //->middleware(['auth', 'signed'])-

Route::post('/email/verification-notification', function (Request $request) {
  $request->user()->sendEmailVerificationNotification();

  //return back()->with('message', 'Verification link sent!');
  return response()->json(['message' => 'Verification link sent!'], 200);
})->middleware(['auth:sanctum', 'throttle:6,1'])->name('verification.send');

//  1         1
//  2  3
//  4  5  6  7
//  8  9 10 11 12 13 14 15
// 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31
// 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63

// newIndex pyramid : parend_subIndex%2
// 0 | 1 : 2 | 3 -> 2+0 2+1  : (0 | 1)
// 0 | 1 : 4 | 5 | 6 | 7 -> 
// 0 | 1 : 8 | 9  10 | 11 | 12 | 13 | 14 | 15 -> 
