<?php

namespace App\Providers;


use App\Models\VerifyEmail as ModelsVerifyEmail;
use Illuminate\Support\ServiceProvider;
use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\Str;

class AppServiceProvider extends ServiceProvider
{
  /**
   * Register any application services.
   */
  public function register(): void
  {
    //
  }

  /**
   * Bootstrap any application services.
   */
  public function boot(): void
  {
    //
    VerifyEmail::toMailUsing(function (object $notifiable, string $url) {

      // Extract the part after 'verify/'
      $afterVerify = Str::after($url, 'verify/');

      // Extract the part before the query parameters
      $beforeQuery = Str::before($afterVerify, '?');

      // Split the string by '/'
      $parts = explode('/', $beforeQuery);

      // Get the values
      $id = $parts[0];
      $token = $parts[1];

      $verifyEmail = new ModelsVerifyEmail();
      $verifyEmail->user_id = $id;
      $verifyEmail->token = $token;
      $verifyEmail->save();


      return (new MailMessage)
        ->subject('اعتبار سنجی ایمل')
        ->line('برا تایید ایمیل، روی دکمه زیر کلیک نمایید.')
        ->action('تایید ایمیل', $url);
    });
  }
}
