<?php

namespace App\Http\Controllers;

use App\Models\Ticket;
use Illuminate\Http\Request;


// new or edited : 0 , approved : 5 , rejected : 10 
class TicketController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index(Request $request)
  {
    if ($request->user()->tokenCan('admin')) {
      $result = Ticket::all();
      return response()->json(
        [
          "error" => false,
          "message" => "Successful.",
          "data" => $result,
        ],
        200
      );
    } else {
      return response()->json(
        [
          "error" => true,
          "message" => "unauthenticated."
        ],
        400
      );
    }
  }

  /**
   * Show the form for creating a new resource.
   */
  public function create()
  {
    //
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(Request $request)
  {

    $request->validate(
      [
        'user_id'  => ['required', 'nullable'],
        'task_id'  => ['required', 'nullable'],
        'photo_url'  => ['required', 'nullable'],
        'content'  => ['required', 'nullable'],
        // 'status'  => ['required', 'nullable'],
        // 'reply'  => ['required', 'nullable'],
      ]
    );
    $user_id = $request->input('user_id');
    $task_id = $request->input('task_id');
    $photo_url = $request->input('photo_url');
    $content = $request->input('content');
    //check send before or not
    $existTicket = Ticket::whereUserId($user_id)->whereTaskId($task_id)->first();
    if ($existTicket) {
      $existTicket->user_id =  $user_id;
      $existTicket->task_id = $task_id;
      $existTicket->photo_url = $photo_url;
      $existTicket->content = $content;
      $existTicket->status = 0;
      $existTicket->save();
      return response()->json(
        [
          "error" => false,
          "message" => "Updated Successfully.",
          "data" => $existTicket,
        ],
        200
      );
    }
    $newTicket = Ticket::create([
      'user_id' => $user_id,
      'task_id' => $task_id,
      'photo_url' => $photo_url,
      'content' => $content,
    ]);
    return response()->json(
      [
        "error" => false,
        "message" => "Successful.",
        "data" => $newTicket,
      ],
      200
    );
  }

  /**
   * Display the specified resource.
   */
  public function show(Request $request)
  {
    $request->validate(
      [
        'id' => ['required',],
      ]
    );
    $id = $request->input('id');
    //1 check the parent
    $thisTicket = Ticket::findOrFail([
      $id
    ]);
    if ($request->user()->tokenCan('admin' || $thisTicket->user_id == $request->user()->id)) {
      return response()->json(
        [
          "error" => false,
          "message" => "Successful.",
          "data" => $thisTicket,
        ],
        200
      );
    } else {

      return response()->json(
        [
          "error" => true,
          "message" => "unauthenticated."
        ],
        400
      );
    }
  }

  /**
   * Show the form for editing the specified resource.
   */
  public function edit(Ticket $ticket)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(Request $request, Ticket $ticket)
  {
    if ($request->user()->tokenCan('admin')) {
      $request->validate(
        [
          'status' => ['required',],
          'reply' => ['required', 'nullable'],
          'id' => ['required',],
        ]
      );
      $status = $request->input('status');
      $reply = $request->input('reply');
      $id = $request->input('id');
      //1 check the parent
      $updatedTicket = Ticket::whereId($id)->update([
        'status' => $status,
        'reply' => $reply,
      ]);
      return response()->json(
        [
          "error" => false,
          "message" => "Successful.",
          "data" => $updatedTicket,
        ],
        200
      );
    } else {
      $request->validate(
        [
          'user_id'  => ['required',],
          'task_id'  => ['required',],
          'photo_url'  => ['required',],
          'content'  => ['required',],
          'id'  => ['id'],
          // 'reply'  => ['required', 'nullable'],
        ]
      );
      $user_id = $request->input('user_id');
      $task_id = $request->input('task_id');
      $photo_url = $request->input('photo_url');
      $content = $request->input('content');
      $id = $request->input('id');
      $updatedTicket = Ticket::find($id)->update([
        'user_id' => $user_id,
        'task_id' => $task_id,
        'photo_url' => $photo_url,
        'content' => $content,
      ]);
      return response()->json(
        [
          "error" => false,
          "message" => "updatedTicket.",
          "data" => $updatedTicket,
        ],
        201
      );
    }
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(Request $request)
  {
    if ($request->user()->tokenCan('admin')) {
      $request->validate(
        [
          'id' => ['required',],
        ]
      );
      $id = $request->input('id');
      //1 check the parent
      $task = Ticket::find($id);

      if ($task) {
        $task->delete();
        return response()->json(['message' => 'Ticket deleted successfully.'], 200);
      } else {
        return response()->json(['message' => 'Ticket not found.'], 404);
      }
    } else {
      return response()->json(
        [
          "error" => true,
          "message" => "unauthenticated."
        ],
        400
      );
    }
  }
}
