<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ticket extends Model
{
  use HasFactory;
  /**
   * The attributes that are mass assignable.
   *
   * @var array<int, string>
   */
  protected $fillable = [
    'user_id',
    'task_id',
    'photo_url',
    'content',
    'status',
    'reply',
  ];

  public function user()
  {
    return $this->belongsTo(User::class);
  }

  public function task()
  {
    return $this->belongsTo(Task::class);
  }
}
