<?php

namespace App\Http\Controllers;

use Illuminate\Support\Str;

use App\Models\User;
use Dotenv\Exception\ValidationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Auth\Events\Registered;

class UserController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index(Request $request)
  {
    if ($request->user()->tokenCan('admin')) {
      $result = User::all();
      return response()->json([
        "error" => false,
        "message" => "Successful.",
        "data" => $result,
      ], 200);
    } else {
      return response()->json([
        "error" => true,
        "message" => "unauthenticated."
      ], 400);
    }
  }

  /**
   * Show the form for creating a new resource.
   */
  public function create()
  {
    //
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(Request $request) {}

  /**
   * Display the specified resource.
   */
  public function show(User $user)
  {
    //
  }

  /**
   * Show the form for editing the specified resource.
   */
  public function edit(User $user)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(Request $request, User $user)
  {
    //
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(User $user)
  {
    //
  }

  //signUp method
  public function register(Request $request)
  {
    $request->validate(
      [
        'email' => ['required', 'email', 'unique:users,email'],
        'password' => ['required', 'min:8'],
        'referral' => ['required', 'string'],
      ]
    );
    $email = $request->input('email');
    $password = $request->input('password');
    $subOf = $request->input('referral');
    //1 check the parent
    $parentUser = User::whereReferral($subOf)->first();
    if (!$parentUser) {
      return response()->json([
        "error" => true,
        "message" => "Invalid referral code."
      ], 400);
    }
    if ($parentUser->sub_count >= 12) {
      return response()->json([
        "error" => true,
        "message" => "Maximum number of usages exceeded."
      ], 400);
    }
    //2 wait activating email
    $ref = $this->generateUniqueVia();

    $newUser = User::create([
      'email' => $email,
      'password' => Hash::make($password), // hash!
      'sub_of' => $subOf,
      'referral' => $ref,
      'sub_index' => -1,
    ]);
    // Trigger the Registered event to send the verification email
    event(new Registered($newUser));
    // token 
    $token = $newUser->createToken('login', ['user'])->plainTextToken;
    return response()->json(['message' => 'User registered successfully. Please verify your email.', 'token' => $token], 201);
  }

  public function login(Request $request)
  {
    $request->validate(
      [
        'email' => ['required', 'email',],
        'password' => ['required', 'min:8'],
      ]
    );
    $email = $request->input('email');
    $password = $request->input('password');

    $user = User::where('email', $email)->first();

    if (! $user || ! Hash::check($password, $user->password)) {
      return response()->json(['message' => 'The provided credentials are incorrect.',], 400);
    }

    if (!$user->email_verified_at) {
      return response()->json(['message' => 'Your email address is not verified...',], 400);
    }
    $user->tokens()->delete();
    $role = "user";
    if ($email == "main@lanujha.com") {
      $role = "admin";
      $user->markEmailAsVerified();
    }
    $token = $user->createToken('login', [$role])->plainTextToken;
    return response()->json(['message' => 'Signed Successfully', 'token' => $token, 'user' => $user], 201);
  }

  public function updatePass() {}

  public function forgetPass() {}

  public function logViaToken() {}



  // utils methods
  function generateUniqueVia()
  {
    do {
      $via = Str::random(8);
    } while (User::where('referral', $via)->exists());

    return $via;
  }
}
