<?php

namespace App\Http\Controllers;

use App\Models\Pyramid;
use Illuminate\Http\Request;

class PyramidController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index(Request $request)
  {
    //
    if ($request->user()->tokenCan('admin')) {
      $result = Pyramid::all();
      return response()->json([
        "error" => false,
        "message" => "Successful.",
        "data" => $result,
      ], 200);
    } else {
      return response()->json([
        "error" => true,
        "message" => "unauthenticated."
      ], 400);
    }
  }

  /**
   * Show the form for creating a new resource.
   */
  public function create()
  {
    //
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(Request $request)
  {
    //
  }

  /**
   * Display the specified resource.
   */
  public function show(Pyramid $pyramid)
  {
    //
  }

  /**
   * Show the form for editing the specified resource.
   */
  public function edit(Pyramid $pyramid)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(Request $request, Pyramid $pyramid)
  {
    //
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(Pyramid $pyramid)
  {
    //
  }

  //
  public function mine(Request $request)
  {
    if ($request->user()->tokenCan('admin')) {
      $result = Pyramid::all();
      return response()->json([
        "error" => false,
        "message" => "Successful.",
        "data" => $result,
      ], 200);
    } else {
      $result = Pyramid::whereUerId($request->user()->id);
      return response()->json([
        "error" => false,
        "message" => "Successful.",
        "data" => $result,
      ], 200);
    }
  }
}
